/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iDate vec4(0.0,0.0,0.0,iGlobalTime)

/////////////////////////////////////////////////////////////////////////////////

// City skyline
// I just picked this off the Sandbox thing and made it smaller and gave it a hazy sunset...
// http://glslsandbox.com/e#22564.0

void main( void ) {

	vec2 p = ( gl_FragCoord.xy / iResolution.xy );
    
	
	float a = .0, t = iDate.w;
	for (int i = 1; i < 35; i++) 
	{
		float fi = float(i);
		float s = floor(500.*p.x/fi+99.*fi+t);
		if (p.y - fi*0.1 < sin(s) - fi*.12) 
        {
			a = float(i) / 32.;
		}
        
	}
 	gl_FragColor = vec4(mix(vec3(0), vec3(1.0-.15*p.y, .4*p.y,.23), 1.-a), 1.0);
}